/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



/**
 * \file:    DM8127_EVM.c
 *
 * \brief:   Generic routines for DM8127 EVM
 *
 * \b \Descr: This file contains the generic routines for test codes for EVM.
 *
 */

/*
 *====================
 * Includes
 *====================
 */
#include "dm8127_types.h"
#include "dm8127_evm.h"
#include "dm8127_platform.h"
#include "stdio.h"
/*
 *====================
 * Static declarations
 *====================
 */

 /*
 *====================
 * Function implementations
 *====================
 */

/***
 * \brief: Routine to initialize the DM8127 EVM board
 *
 * \b Descr: This routine initializes the DM8127 EVM Base Board
 *
 * \param:  VOID
 * \return: SUCCESS for success  - Description
 *          FAILED for error   - Description
 *
 */
STATUS DM8127_EVM_Init
(
	void
)
{
//	printf ("Test Suite version number is %d.%d.\r\n", MAJOR_VERSION, MINOR_VERSION);
	printf ("Build Date =  %s : Time = %s.\r\n", __DATE__, __TIME__);
	return (SUCCESS);
}
#if 0
SINT32 Uart_stringSend(const char* pu8string)
{
	UINT32 u32len;
	UINT32 u32count;

	u32len = strlen((const char *)pu8string);
	for (u32count = 0; u32count < u32len; u32count ++)
	{
		uart_send( Hanhler_uart0, pu8string[u32count], uart_timeout );
	}
}

SINT32 platform_write(const char *format, ... )
{
	va_list arg_ptr;
	UINT32	u32count;
	UINT32  length;

	/* sanity check */
	if (strlen(format) > MAX_LEN)
	{
#ifdef DEBG
		printf("\r\n Input error \r\n");
#endif
		 return -1;
	}

#ifdef NO_LONGER_VALID
	/* Open Uart Handle */
	if (( uart0 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
	{
#ifdef DEBG
	  printf("\r\n failed to initialize the error \r\n");
#endif
	  	  return -1;
	}
#endif
	va_start( arg_ptr, format );

	length = vsprintf( (char *)write_buffer, format, arg_ptr );
	va_end( arg_ptr );

	if (write_type == PLATFORM_WRITE_UART)
	{
		for (u32count = 0; u32count < length; u32count ++)
		{
			if (write_buffer[u32count] == '\n') {
				uart_send(Hanhler_uart0, (unsigned char)0x0D, uart_timeout);
				uart_send(Hanhler_uart0, (unsigned char)0x0A, uart_timeout);
			}
			else {
				uart_send(Hanhler_uart0, (unsigned char)write_buffer[u32count], uart_timeout);
			}
		}
	}
	else if (write_type == PLATFORM_WRITE_PRINTF)
	{
		/*Used to print on the CCS console*/
		printf("%s", write_buffer);
		fflush(stdout);
	}
	return 0;
}

SINT32 platform_read(UINT8 *data, UINT32 length)
{
	SINT32 status = 0;
	UINT32 count = 0;
	UART_Handle uart0;

	/* Open Uart Handle */
		    if ( ( uart0 = _UART_open( UART_0, /*115200*/ 26 ) ) == 0 )
		        return -1;

	if (read_type == PLATFORM_READ_UART)
	{
		/* Wait till an input is provided */
		do
		{
		status = uart_recv (uart0, data, uart_timeout);//
		if(status == 0)
		{
			/* Check if user pressed enter */
			if((*data == 0xD) || (*data == 0x1B))
			{
			   *data = '\0';
			   break;
			}

			uart_send(uart0, *data, uart_timeout);

			count++;
			data++;
		}
		else
		{
			platform_write("UART read error");
			return -1;
		}
		} while ((status != 0) || (count != length));
	}

	if (read_type == PLATFORM_READ_SCANF)
		{
			count = scanf("%s", data);
		}

return (count);
}
#endif

/***
 * \brief: delay routine.
 *
 * \param: delay_count [IN]  number of delay count.
 *
 * \return: VOID
 */
void delay
(
	SINT32 delay_count
)
{
	while (delay_count --);
	return;
}
#ifdef DISABLE
/**
 * \n \brief Delay loop used for Micro-second delay
 *
 * Delay loop used for Micro-second delay
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
void DM8127_wait
(
	UINT32 u32Delay
)
{
    volatile UINT32 u32LoopCntr;
    for ( u32LoopCntr = 0 ; u32LoopCntr < u32Delay ; u32LoopCntr++ ){ };
}


/** **************************************************************************
 * \n \brief Micro-second delay routine
 *
 * Utility routine for micro-seconds
 *
 * \param  u32usec	[IN] 	Delay in micro-seconds
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
void DM8127_usecDelay
(
	UINT32 u32usec
)
{
    #ifdef ARM_SIDE
        DM8127_wait( u32usec * 2 );
    #elif DSP_SIDE
        DM8127_wait( u32usec * 28 );
    #endif
    DM8127_wait( u32usec * 2 );
}
#endif

